/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.DurabilityShieldModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class FalsiteModifier
extends DurabilityShieldModifier
implements TooltipModifierHook {
    private static final Component FALSITE = TConstruct.makeTranslation((String)"modifier", (String)"falsite");
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "falsite");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.TOOLTIP, ModifierHooks.TOOL_DAMAGE);
    }

    public boolean shouldDisplay(boolean advanced) {
        return false;
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(this.KEY);
        return null;
    }

    public int onDamageTool(IToolStackView iToolStackView, ModifierEntry modifierEntry, int i, @Nullable LivingEntity livingEntity) {
        int falsiteUses = iToolStackView.getPersistentData().getInt(this.KEY);
        if (falsiteUses > 0) {
            iToolStackView.getPersistentData().putInt(this.KEY, falsiteUses -= i);
            if (falsiteUses <= 0) {
                return Math.abs(falsiteUses);
            }
            return 0;
        }
        return i;
    }

    public int getShieldCapacity(IToolStackView iToolStackView, ModifierEntry modifierEntry) {
        return 0;
    }

    @Nullable
    public Boolean showDurabilityBar(IToolStackView iToolStackView, ModifierEntry modifierEntry) {
        return iToolStackView.getPersistentData().getInt(this.KEY) <= Math.max(Math.floorDiv(iToolStackView.getStats().getInt((IToolStat)ToolStats.DURABILITY), 5), 30) ? Boolean.valueOf(true) : null;
    }

    public int getDurabilityRGB(IToolStackView iToolStackView, ModifierEntry modifierEntry) {
        if (iToolStackView.getPersistentData().getInt(this.KEY) > 0) {
            return Mth.m_14159_((float)0.5f, (float)1.0f, (float)1.0f);
        }
        return -1;
    }

    public int getDurabilityWidth(IToolStackView tool, ModifierEntry modifier) {
        int shield = tool.getPersistentData().getInt(this.KEY);
        return shield > 0 ? DurabilityDisplayModifierHook.getWidthFor((int)shield, (int)Math.max(Math.floorDiv(tool.getStats().getInt((IToolStat)ToolStats.DURABILITY), 5), 30)) : 0;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @javax.annotation.Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (tool.getPersistentData().getInt(this.KEY) > 0 && tooltipKey == TooltipKey.SHIFT) {
            tooltip.add((Component)Component.m_237115_((String)"").m_7220_(FALSITE).m_130946_(String.valueOf(tool.getPersistentData().getInt(this.KEY))).m_130946_(" / ").m_130946_(String.valueOf(Math.max(Math.floorDiv(tool.getStats().getInt((IToolStat)ToolStats.DURABILITY), 5), 30))).m_130940_(ChatFormatting.GRAY));
        }
    }
}

